#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ExceptionReport : BaseTest 
	{
		private System.DateTime _startDate = System.DateTime.Now.AddYears(-1);
		private System.DateTime _endDate = System.DateTime.Now.AddYears(1);
		private System.DateTime _invalidStart = System.DateTime.Now.AddYears(1);
		private System.DateTime _invalidEnd = System.DateTime.Now.AddYears(-1);
		

		private System.Guid _patientGuid = System.Guid.NewGuid();
		private System.Guid _unitGuid = System.Guid.NewGuid();

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
		}

		//TODO: All the code in ExceptionReport - "return new DataSet();" - can be removed - it's unreachable
		//		StoredProc's always return at least 1 table

		[Test]
		public void GetExceptionReportLabelMismatch_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportLabelMismatch(this.TestDivisionCode, this._startDate, this._endDate);
		
			ValidateExceptionReportLabelMismatch(dsTest);
		}

		[Test]
		public void GetExceptionReportLabelMismatch_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportLabelMismatch(this.TestDivisionCode, this._invalidStart, this._invalidEnd);
		
			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportLabelMismatch_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportLabelMismatch(_unitGuid);
		
			ValidateExceptionReportLabelMismatch(dsTest);
		}

		[Test]
		public void GetExceptionReportLabelMismatch_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportLabelMismatch(System.Guid.NewGuid());
		
			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientAboRh_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRH(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportPatientAboRH(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientAboRh_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRH(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientAboRh_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRH(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportPatientAboRH(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientAboRh_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRH(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientAboRHDiscrepancy_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRHDiscrepancy(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportPatientAboRHDiscrepancy(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientAboRHDiscrepancy_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRHDiscrepancy(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientAboRHDiscrepancy_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRHDiscrepancy(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportPatientAboRHDiscrepancy(dsTest);		
		}

		[Test]
		public void GetExceptionReportPatientAboRHDiscrepancy_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAboRHDiscrepancy(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientAntigenDiscrepancy_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAntigenDiscrepancy(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportPatientAntigenDiscrepancy(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientAntigenDiscrepancy_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAntigenDiscrepancy(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientAntigenDiscrepancy_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAntigenDiscrepancy(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportPatientAntigenDiscrepancy(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientAntigenDiscrepancy_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientAntigenDiscrepancy(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientTest_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTest(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportPatientTest(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientTest_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTest(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientTest_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTest(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportPatientTest(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientTest_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTest(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportPatientTestInactivated_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTestInactivated(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportPatientTestInactivated(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientTestInactivated_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTestInactivated(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		
		[Test]
		public void GetExceptionReportPatientTestInactivated_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTestInactivated(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportPatientTestInactivated(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientTestInactivated_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientTestInactivated(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportExpiredUnitReceived_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportExpiredUnitReceived(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportExpiredUnitReceived(dsTest);
		}

		[Test]
		public void GetExceptionReportExpiredUnitReceived_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportExpiredUnitReceived(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetExceptionReportQC_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQC(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportQC(dsTest);
		}

		[Test]
		public void GetExceptionReportQC_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQC(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		
		[Test]
		public void GetExceptionReportQC_Guid_Pass()
		{
			System.Guid unitGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitGuid FROM ExceptionQc WHERE BloodUnitGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "'");

			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQC(unitGuid);

			ValidateExceptionReportQC(dsTest);
		}

		[Test]
		public void GetExceptionReportQC_Guid_Fail()
		{
			System.Guid unitGuid = System.Guid.NewGuid();

			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQC(unitGuid);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

				
		[Test]
		public void GetExceptionReportQC_Division_Guid_Pass()
		{
			Guid reagentGuid = DataCreator.GetRandomRecordGuid(TABLES.Reagent.TableName, "");
			Guid rackGuid = DataCreator.GetRandomRecordGuid(TABLES.Rack.TableName, "");
			Guid buGuid = DataCreator.GetRandomRecordGuid(TABLES.BloodUnit.TableName, "");
			Guid patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");

			BOL.ExceptionReport tmp = new BOL.ExceptionReport(Common.ExceptionType.QC_not_performed_on_rack_used_for_testing, "UT_8398", Common.LogonUser.LogonUserName);
			tmp.GenerateExceptionQC(reagentGuid, rackGuid, buGuid, patientGuid, "0", "1", "2", Common.LogonUser.LogonUserName);

			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQC(this.TestDivisionCode, patientGuid);

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(15, dsTest.Tables[0].Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetExceptionReportQC_Division_Guid_Fail()
		{
			System.Guid patientGuid = System.Guid.NewGuid();

			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQC(this.TestDivisionCode, patientGuid);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportQCInactivated_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQCInactivated(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportQCInactivated(dsTest);
		}

		[Test]
		public void GetExceptionReportQCInactivated_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQCInactivated(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportQCNotPerformed_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQCNotPerformed(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportQCNotPerformed(dsTest, false);
		}

		[Test]
		public void GetExceptionReportQCNotPerformed_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQCNotPerformed(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		
		[Test]
		public void GetExceptionReportQCNotPerformed_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQCNotPerformed(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportQCNotPerformed(dsTest, true);
		}

		[Test]
		public void GetExceptionReportQCNotPerformed_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQCNotPerformed(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportQuarantine_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQuarantine(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportQuarantine(dsTest);
		}

		[Test]
		public void GetExceptionReportQuarantine_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQuarantine(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportQuarantine_String_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQuarantine(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportQuarantine(dsTest);
		}

		[Test]
		public void GetExceptionReportQuarantine_String_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQuarantine(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportQuarantine_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQuarantine(_unitGuid);

			ValidateExceptionReportQuarantine(dsTest);
		}

		[Test]
		public void GetExceptionReportQuarantine_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportQuarantine(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportReflexTest_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReflexTest(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportReflexTest(dsTest);
		}

		[Test]
		public void GetExceptionReportReflexTest_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReflexTest(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportReflexTest_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReflexTest(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportReflexTest(dsTest);
		}

		[Test]
		public void GetExceptionReportReflexTest_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReflexTest(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportSpecimen_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportSpecimen(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportSpecimen(dsTest);
		}

		[Test]
		public void GetExceptionReportSpecimen_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportSpecimen(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportSpecimen_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportSpecimen(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportSpecimen(dsTest);
		}

		[Test]
		public void GetExceptionReportSpecimen_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportSpecimen(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitAboRh_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitAboRH(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportUnitAboRh(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitAboRh_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitAboRH(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitAboRh_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitAboRH(_unitGuid);

			ValidateExceptionReportUnitAboRh(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitAboRh_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitAboRH(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitModification_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitModification(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportUnitModification(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitModification_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitModification(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitModification_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitModification(_unitGuid);

			ValidateExceptionReportUnitModification(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitModification_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitModification(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitSelection_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSelection(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportUnitSelection(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitSelection_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSelection(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitSelection_String_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSelection(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportUnitSelection(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitSelection_String_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSelection(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportUnitSelection_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSelection(_unitGuid);

			ValidateExceptionReportUnitSelection(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitSelection_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSelection(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportRemoveFinalUnitStatus_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportRemoveFinalUnitStatus(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportRemoveFinalUnitStatus(dsTest);
		}

		[Test]
		public void GetExceptionReportRemoveFinalUnitStatus_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportRemoveFinalUnitStatus(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportRemoveFinalUnitStatus_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportRemoveFinalUnitStatus(this._unitGuid);

			ValidateExceptionReportRemoveFinalUnitStatus(dsTest);
		}

		[Test]
		public void GetExceptionReportRemoveFinalUnitStatus_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportRemoveFinalUnitStatus(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportReturnIssuedUnit_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportReturnIssuedUnit(dsTest);
		}

		[Test]
		public void GetExceptionReportReturnIssuedUnit_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportReturnIssuedUnit_String_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportReturnIssuedUnit(dsTest);
		}

		[Test]
		public void GetExceptionReportReturnIssuedUnit_String_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportReturnIssuedUnit_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(_unitGuid);

			ValidateExceptionReportReturnIssuedUnit(dsTest);
		}

		[Test]
		public void GetExceptionReportReturnIssuedUnit_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportAboIncompatibleTransfusion_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAboIncompatibleTransfusion(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportAboIncompatibleTransfusion(dsTest);
		}

		[Test]
		public void GetExceptionReportAboIncompatibleTransfusion_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAboIncompatibleTransfusion(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportAboIncompatibleTransfusion_String_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAboIncompatibleTransfusion(this.TestDivisionCode, _patientGuid);

			ValidateExceptionReportAboIncompatibleTransfusion(dsTest);
		}

		[Test]
		public void GetExceptionReportAboIncompatibleTransfusion_String_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAboIncompatibleTransfusion(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportCautionTagBTRF_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(UnitTestConfig.TestDivisionCode,DateTime.Now, DateTime.Now);
			ValidateExceptionReportCautionTagBTRF(dsTest);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetExceptionReportCautionTagBTRF_DivisionCode_Fail()
		{
			DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(string.Empty, DateTime.Now, DateTime.Now);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetExceptionReportCautionTagBTRF_StartDate_Fail()
		{
			DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(UnitTestConfig.TestDivisionCode, DateTime.MinValue, DateTime.Now);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetExceptionReportCautionTagBTRF_EndDate_Fail()
		{
			DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(string.Empty, DateTime.Now, DateTime.MinValue);
		}

		[Test]
		public void GetExceptionReportCautionTagBTRF_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportCautionTagBTRF(dsTest);
		}

		[Test]
		public void GetExceptionReportCautionTagBTRF_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportUnitIssue_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitIssue(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportUnitIssue(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitIssue_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitIssue(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportEmergencyIssueOrder_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueOrder(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportEmergencyIssueOrder(dsTest);
		}

		[Test]
		public void GetExceptionReportEmergencyIssueOrder_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueOrder(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportEmergencyIssueOrder_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueOrder(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportEmergencyIssueOrder(dsTest);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetExceptionReportEmergencyIssueOrder_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueOrder(this.TestDivisionCode, System.Guid.Empty);
		}
		
		[Test]
		public void GetExceptionReportUnitIssue_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitIssue(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportUnitIssue(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitIssue_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitIssue(this.TestDivisionCode, System.Guid.Empty);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportTrwSpecimen_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTrwSpecimen(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportTrwSpecimen(dsTest);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetExceptionReportTrwSpecimen_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTrwSpecimen(this.TestDivisionCode, System.DateTime.MinValue, System.DateTime.MinValue);
		}
		
		[Test]
		public void GetExceptionReportTrwSpecimen_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTrwSpecimen(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportTrwSpecimen(dsTest);
		}

		[Test]
		public void GetExceptionReportTrwSpecimen_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTrwSpecimen(this.TestDivisionCode, System.Guid.Empty);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportTransfusionReactionWorkup_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusionReactionWorkup(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportTransfusionReactionWorkup(dsTest);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetExceptionReportTransfusionReactionWorkup_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusionReactionWorkup(this.TestDivisionCode, System.DateTime.MinValue, System.DateTime.MinValue);
		}
		
		[Test]
		public void GetExceptionReportTransfusionReactionWorkup_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusionReactionWorkup(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportTransfusionReactionWorkup(dsTest);
		}

		[Test]
		public void GetExceptionReportTransfusionReactionWorkup_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusionReactionWorkup(this.TestDivisionCode, System.Guid.Empty);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportAntigenTestInvalidated_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAntigenTestInvalidated(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportAntigenTestInvalidated(dsTest);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetExceptionReportAntigenTestInvalidated_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAntigenTestInvalidated(this.TestDivisionCode, System.DateTime.MinValue, System.DateTime.MinValue);
		}
		
		[Test]
		public void GetExceptionReportAntigenTestInvalidated_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAntigenTestInvalidated(this._unitGuid);

			ValidateExceptionReportAntigenTestInvalidated(dsTest);
		}

		[Test]
		public void GetExceptionReportAntigenTestInvalidated_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportAntigenTestInvalidated(System.Guid.Empty);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportUnitTest_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitTest(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportUnitTest(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitTest_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitTest(this.TestDivisionCode, this._invalidEnd, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportTransfusion_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusion(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportTransfusion(dsTest);
		}

		[Test]
		public void GetExceptionReportTransfusion_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusion(this.TestDivisionCode, this._invalidEnd, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportTransfusion_String_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusion(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportTransfusion(dsTest);
		}

		[Test]
		public void GetExceptionReportTransfusion_String_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusion(this.TestDivisionCode, this._patientGuid);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportTransfusion_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusion(this._unitGuid);

			ValidateExceptionReportTransfusion(dsTest);
		}

		[Test]
		public void GetExceptionReportTransfusion_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportTransfusion(this._unitGuid);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportExpiredTask_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportExpiredTask(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportExpiredTask(dsTest);
		}

		[Test]
		public void GetExceptionReportExpiredTask_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportExpiredTask(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportEmergencyIssueUnitTest_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueUnitTest(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportEmergencyIssueUnitTest(dsTest);
		}

		[Test]
		public void GetExceptionReportEmergencyIssueUnitTest_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueUnitTest(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportEmergencyIssueUnitTest_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueUnitTest(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportEmergencyIssueUnitTest(dsTest);
		}

		[Test]
		public void GetExceptionReportEmergencyIssueUnitTest_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportEmergencyIssueUnitTest(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportUnitSupply_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSupply(this._unitGuid);

			ValidateExceptionReportUnitSupply(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitSupply_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSupply(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportUnitSupply_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSupply(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportUnitSupply(dsTest);
		}

		[Test]
		public void GetExceptionReportUnitSupply_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportUnitSupply(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportPatientRestriction_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientRestriction(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportPatientRestriction(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientRestriction_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientRestriction(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportPatientRestriction_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientRestriction(this.TestDivisionCode, this._patientGuid);

			ValidateExceptionReportPatientRestriction(dsTest);
		}

		[Test]
		public void GetExceptionReportPatientRestriction_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportPatientRestriction(this.TestDivisionCode, System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}
		
		[Test]
		public void GetExceptionReportInconclusiveCrossmatch_Dates_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportInconclusiveCrossmatch(this.TestDivisionCode, this._startDate, this._endDate);

			ValidateExceptionReportInconclusiveCrossmatch(dsTest);
		}

		[Test]
		public void GetExceptionReportInconclusiveCrossmatch_Dates_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportInconclusiveCrossmatch(this.TestDivisionCode, this._invalidStart, this._invalidEnd);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetExceptionReportExpiredUnitReceived_Guid_Pass()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportExpiredUnitReceived(_unitGuid);

			ValidateExceptionReportExpiredUnitReceived(dsTest);
		}

		[Test]
		public void GetExceptionReportExpiredUnitReceived_Guid_Fail()
		{
			DataSet dsTest = DAL.ExceptionReport.GetExceptionReportExpiredUnitReceived(System.Guid.NewGuid());

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Rows.Count");
		}



		#region Validation Methods - for code resuse

		public static void ValidateExceptionReportPatientRestriction(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(20, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ExceptionPatientRestrictionGuid), TABLES.ExceptionPatientRestriction.ExceptionPatientRestrictionGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ExceptionTypeId), TABLES.ExceptionPatientRestriction.ExceptionTypeId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.UnitId), TABLES.ExceptionPatientRestriction.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.UnitGuid), TABLES.ExceptionPatientRestriction.UnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.UnitAboRh), TABLES.ExceptionPatientRestriction.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ProductShortName), TABLES.ExceptionPatientRestriction.ProductShortName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ProductCode), TABLES.ExceptionPatientRestriction.ProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.UnitExpirationDate), TABLES.ExceptionPatientRestriction.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.SpecialTesting), TABLES.ExceptionPatientRestriction.SpecialTesting);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.DonationType), TABLES.ExceptionPatientRestriction.DonationType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.RestrictedPatientName), TABLES.ExceptionPatientRestriction.RestrictedPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.RestrictedPatientId), TABLES.ExceptionPatientRestriction.RestrictedPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.RestrictedPatientGuid), TABLES.ExceptionPatientRestriction.RestrictedPatientGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ExceptionUser), TABLES.ExceptionPatientRestriction.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ExceptionComment), TABLES.ExceptionPatientRestriction.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.ExceptionDate), TABLES.ExceptionPatientRestriction.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.DivisionCode), TABLES.ExceptionPatientRestriction.DivisionCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.LastUpdateDate), TABLES.ExceptionPatientRestriction.LastUpdateDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientRestriction.LastUpdateUser), TABLES.ExceptionPatientRestriction.LastUpdateUser);
		}


		public static void ValidateExceptionReportInconclusiveCrossmatch(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(13, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.ExceptionInconclusiveCrossmatchGuid), TABLES.ExceptionInconclusiveCrossmatch.ExceptionInconclusiveCrossmatchGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.PatientName), TABLES.ExceptionInconclusiveCrossmatch.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.PatientId), TABLES.ExceptionInconclusiveCrossmatch.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.SpecimenUid), TABLES.ExceptionInconclusiveCrossmatch.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.BloodUnitId), TABLES.ExceptionInconclusiveCrossmatch.BloodUnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.UnitProductCode), TABLES.ExceptionInconclusiveCrossmatch.UnitProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.SystemInterp), TABLES.ExceptionInconclusiveCrossmatch.SystemInterp);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.TechInterp), TABLES.ExceptionInconclusiveCrossmatch.TechInterp);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.ExceptionComment), TABLES.ExceptionInconclusiveCrossmatch.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.ExceptionUser), TABLES.ExceptionInconclusiveCrossmatch.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.ExceptionDate), TABLES.ExceptionInconclusiveCrossmatch.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionInconclusiveCrossmatch.TestingTechName), TABLES.ExceptionInconclusiveCrossmatch.TestingTechName);
		}


		public static void ValidateExceptionReportEmergencyIssueUnitTest(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(15, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.ExceptionEmergencyIssueUnitTestGuid), TABLES.ExceptionEmergencyIssueUnitTest.ExceptionEmergencyIssueUnitTestGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.PatientName), TABLES.ExceptionEmergencyIssueUnitTest.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.PatientId), TABLES.ExceptionEmergencyIssueUnitTest.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.PatientAboRh), TABLES.ExceptionEmergencyIssueUnitTest.PatientAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.TestPerformed), TABLES.ExceptionEmergencyIssueUnitTest.TestPerformed);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.TestInterp), TABLES.ExceptionEmergencyIssueUnitTest.TestInterp);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.UnitId), TABLES.ExceptionEmergencyIssueUnitTest.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.UnitAboRh), TABLES.ExceptionEmergencyIssueUnitTest.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.UnitProductType), TABLES.ExceptionEmergencyIssueUnitTest.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.UnitExpirationDate), TABLES.ExceptionEmergencyIssueUnitTest.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.TestingTechName), TABLES.ExceptionEmergencyIssueUnitTest.TestingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.ExceptionUser), TABLES.ExceptionEmergencyIssueUnitTest.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.ExceptionComment), TABLES.ExceptionEmergencyIssueUnitTest.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueUnitTest.ExceptionDate), TABLES.ExceptionEmergencyIssueUnitTest.ExceptionDate);
		}


		public static void ValidateExceptionReportUnitSupply(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(12, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitId), TABLES.ExceptionUnitModification.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitProductType), TABLES.ExceptionUnitModification.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.SupplyType), TABLES.ExceptionUnitModification.SupplyType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.SupplyName), TABLES.ExceptionUnitModification.SupplyName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.SupplyLotNumber), TABLES.ExceptionUnitModification.SupplyLotNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.SupplyExpirationDate), TABLES.ExceptionUnitModification.SupplyExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ExceptionComment), TABLES.ExceptionUnitModification.ExceptionComment);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(ARTIFICIAL.ProcessTechId), ARTIFICIAL.ProcessTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(ARTIFICIAL.LoginTechId), ARTIFICIAL.LoginTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.DivisionCode), TABLES.ExceptionUnitModification.DivisionCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ExceptionDate), TABLES.ExceptionUnitModification.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);

		}

		public static void ValidateExceptionReportExpiredTask(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(13, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.ExceptionExpiredTaskGuid), TABLES.ExceptionExpiredTask.ExceptionExpiredTaskGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.PatientName), TABLES.ExceptionExpiredTask.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.PatientId), TABLES.ExceptionExpiredTask.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.CprsOrderNumber), TABLES.ExceptionExpiredTask.CprsOrderNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.SpecimenUid), TABLES.ExceptionExpiredTask.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.ComponentClassOrdered), TABLES.ExceptionExpiredTask.ComponentClassOrdered);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.Quantity), TABLES.ExceptionExpiredTask.Quantity);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.DateWanted), TABLES.ExceptionExpiredTask.DateWanted);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.LoginTechName), TABLES.ExceptionExpiredTask.LoginTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.ExceptionComment), TABLES.ExceptionExpiredTask.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.ExceptionUser), TABLES.ExceptionExpiredTask.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredTask.ExceptionDate), TABLES.ExceptionExpiredTask.ExceptionDate);
		}


		public static void ValidateExceptionReportTransfusion(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(12, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionTransfusionGuid), TABLES.ExceptionTransfusion.ExceptionTransfusionGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.TransfusedPatientName), TABLES.ExceptionTransfusion.TransfusedPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.TransfusedPatientId), TABLES.ExceptionTransfusion.TransfusedPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.TransfusedPatientAboRh), TABLES.ExceptionTransfusion.TransfusedPatientAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitId), TABLES.ExceptionTransfusion.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitProductType), TABLES.ExceptionTransfusion.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitAboRh), TABLES.ExceptionTransfusion.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitExpirationDate), TABLES.ExceptionTransfusion.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionUser), TABLES.ExceptionTransfusion.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionComment), TABLES.ExceptionTransfusion.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionDate), TABLES.ExceptionTransfusion.ExceptionDate);
		}


		public static void ValidateExceptionReportUnitTest(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(11, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionPatientTestGuid), TABLES.ExceptionPatientTest.ExceptionPatientTestGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.UnitId), TABLES.ExceptionPatientTest.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestName), TABLES.ExceptionPatientTest.TestName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestInterp), TABLES.ExceptionPatientTest.TestInterp);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestDate), TABLES.ExceptionPatientTest.TestDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ReactivityPhase), TABLES.ExceptionPatientTest.ReactivityPhase);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionComment), TABLES.ExceptionPatientTest.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionUser), TABLES.ExceptionPatientTest.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionDate), TABLES.ExceptionPatientTest.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestingTechName), TABLES.ExceptionPatientTest.TestingTechName);
		}


		public static void ValidateExceptionReportAntigenTestInvalidated(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(12, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.ExceptionAntigenTestGuid), TABLES.ExceptionAntigenTest.ExceptionAntigenTestGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.UnitId), TABLES.ExceptionAntigenTest.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.ProductShortName), TABLES.ExceptionAntigenTest.ProductShortName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.TestPerformed), TABLES.ExceptionAntigenTest.TestPerformed);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.InvalidatedResult), TABLES.ExceptionAntigenTest.InvalidatedResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.InvalidatedDate), TABLES.ExceptionAntigenTest.InvalidatedDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.PreviousTestingTechName), TABLES.ExceptionAntigenTest.PreviousTestingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.CurrentTestingTechName), TABLES.ExceptionAntigenTest.CurrentTestingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.ExceptionComment), TABLES.ExceptionAntigenTest.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.ExceptionUser), TABLES.ExceptionAntigenTest.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionAntigenTest.ExceptionDate), TABLES.ExceptionAntigenTest.ExceptionDate);
		}


		public static void ValidateExceptionReportTransfusionReactionWorkup(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(20, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ExceptionTransfusionReactionWorkupGuid), TABLES.ExceptionTransfusionReactionWorkup.ExceptionTransfusionReactionWorkupGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.UnitId), TABLES.ExceptionTransfusionReactionWorkup.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.UnitAboRh), TABLES.ExceptionTransfusionReactionWorkup.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ProductCode), TABLES.ExceptionTransfusionReactionWorkup.ProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ProductShortName), TABLES.ExceptionTransfusionReactionWorkup.ProductShortName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.UnitExpirationDate), TABLES.ExceptionTransfusionReactionWorkup.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.UnitDonationType), TABLES.ExceptionTransfusionReactionWorkup.UnitDonationType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.TrwPatientName), TABLES.ExceptionTransfusionReactionWorkup.TrwPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.TrwPatientId), TABLES.ExceptionTransfusionReactionWorkup.TrwPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.AssignedPatientName), TABLES.ExceptionTransfusionReactionWorkup.AssignedPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.AssignedPatientId), TABLES.ExceptionTransfusionReactionWorkup.AssignedPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ClericalCheckFailed), TABLES.ExceptionTransfusionReactionWorkup.ClericalCheckFailed);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.IssueDate), TABLES.ExceptionTransfusionReactionWorkup.IssueDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.IssueTechId), TABLES.ExceptionTransfusionReactionWorkup.IssueTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.TrwDate), TABLES.ExceptionTransfusionReactionWorkup.TrwDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.TrwTechId), TABLES.ExceptionTransfusionReactionWorkup.TrwTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ExceptionComment), TABLES.ExceptionTransfusionReactionWorkup.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ExceptionUser), TABLES.ExceptionTransfusionReactionWorkup.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusionReactionWorkup.ExceptionDate), TABLES.ExceptionTransfusionReactionWorkup.ExceptionDate);
		}


		public static void ValidateExceptionReportTrwSpecimen(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(13, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.ExceptionTrwSpecimenGuid), TABLES.ExceptionTrwSpecimen.ExceptionTrwSpecimenGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.TrwPatientName), TABLES.ExceptionTrwSpecimen.TrwPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.TrwPatientId), TABLES.ExceptionTrwSpecimen.TrwPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.SpecimenUid), TABLES.ExceptionTrwSpecimen.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.SpecimenPatientName), TABLES.ExceptionTrwSpecimen.SpecimenPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.SpecimenPatientId), TABLES.ExceptionTrwSpecimen.SpecimenPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.ClericalCheckFailed), TABLES.ExceptionTrwSpecimen.ClericalCheckFailed);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.TrwDate), TABLES.ExceptionTrwSpecimen.TrwDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.TrwTechId), TABLES.ExceptionTrwSpecimen.TrwTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.ExceptionComment), TABLES.ExceptionTrwSpecimen.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.ExceptionUser), TABLES.ExceptionTrwSpecimen.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTrwSpecimen.ExceptionDate), TABLES.ExceptionTrwSpecimen.ExceptionDate);
		}


		public static void ValidateExceptionReportEmergencyIssueOrder(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(16, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.ExceptionEmergencyIssueOrderGuid), TABLES.ExceptionEmergencyIssueOrder.ExceptionEmergencyIssueOrderGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.PatientName), TABLES.ExceptionEmergencyIssueOrder.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.PatientId), TABLES.ExceptionEmergencyIssueOrder.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.PatientGuid), TABLES.ExceptionEmergencyIssueOrder.PatientGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.CprsOrderNumber), TABLES.ExceptionEmergencyIssueOrder.CprsOrderNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.UrgencyIndicator), TABLES.ExceptionEmergencyIssueOrder.UrgencyIndicator);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.ComponentClassOrdered), TABLES.ExceptionEmergencyIssueOrder.ComponentClassOrdered);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.DateWanted), TABLES.ExceptionEmergencyIssueOrder.DateWanted);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.DateAcknowledged), TABLES.ExceptionEmergencyIssueOrder.DateAcknowledged);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.ProcessingTechName), TABLES.ExceptionEmergencyIssueOrder.ProcessingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.ExceptionUser), TABLES.ExceptionEmergencyIssueOrder.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.ExceptionComment), TABLES.ExceptionEmergencyIssueOrder.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.ExceptionDate), TABLES.ExceptionEmergencyIssueOrder.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionEmergencyIssueOrder.DivisionCode), TABLES.ExceptionEmergencyIssueOrder.DivisionCode);
		}


		public static void ValidateExceptionReportRemoveFinalUnitStatus(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(16, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.ExceptionRemoveFinalUnitStatusGuid), TABLES.ExceptionRemoveFinalUnitStatus.ExceptionRemoveFinalUnitStatusGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.UnitGuid), TABLES.ExceptionRemoveFinalUnitStatus.UnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.UnitId), TABLES.ExceptionRemoveFinalUnitStatus.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.UnitAboRh), TABLES.ExceptionRemoveFinalUnitStatus.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitProductType), TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitExpirationDate), TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitStatus), TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitStatus);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitVolume), TABLES.ExceptionRemoveFinalUnitStatus.PreviousUnitVolume);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitProductType), TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitExpirationDate), TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitStatus), TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitStatus);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitVolume), TABLES.ExceptionRemoveFinalUnitStatus.CurrentUnitVolume);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.ExceptionUser), TABLES.ExceptionRemoveFinalUnitStatus.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.ExceptionComment), TABLES.ExceptionRemoveFinalUnitStatus.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionRemoveFinalUnitStatus.ExceptionDate), TABLES.ExceptionRemoveFinalUnitStatus.ExceptionDate);
		}

		public static void ValidateExceptionReportUnitIssue(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(31, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.ExceptionUnitIssueGuid), TABLES.ExceptionUnitIssue.ExceptionUnitIssueGuid);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.ExceptionTypeId), TABLES.ExceptionUnitIssue.ExceptionTypeId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.PatientName), TABLES.ExceptionUnitIssue.PatientName);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.PatientId), TABLES.ExceptionUnitIssue.PatientId);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.PatientGuid), TABLES.ExceptionUnitIssue.PatientGuid);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.HistoricAboRh), TABLES.ExceptionUnitIssue.HistoricAboRh);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.TechAboRh), TABLES.ExceptionUnitIssue.TechAboRh);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.SystemAboRh), TABLES.ExceptionUnitIssue.SystemAboRh);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.PatientAntibodies), TABLES.ExceptionUnitIssue.PatientAntibodies);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.PatientTransfusionRequirements), TABLES.ExceptionUnitIssue.PatientTransfusionRequirements);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.SpecimenUid), TABLES.ExceptionUnitIssue.SpecimenUid);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitId), TABLES.ExceptionUnitIssue.UnitId);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitGuid), TABLES.ExceptionUnitIssue.UnitGuid);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitProductType), TABLES.ExceptionUnitIssue.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitAboRh), TABLES.ExceptionUnitIssue.UnitAboRh);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitExpirationDate), TABLES.ExceptionUnitIssue.UnitExpirationDate);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitAntigens), TABLES.ExceptionUnitIssue.UnitAntigens);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitDonationType), TABLES.ExceptionUnitIssue.UnitDonationType);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.UnitTestingEntry), TABLES.ExceptionUnitIssue.UnitTestingEntry);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.OrderIndicator), TABLES.ExceptionUnitIssue.OrderIndicator);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.OrderedBy), TABLES.ExceptionUnitIssue.OrderedBy);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.IssuedToLocation), TABLES.ExceptionUnitIssue.IssuedToLocation);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.TransporterName), TABLES.ExceptionUnitIssue.TransporterName);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.IssuingTechName), TABLES.ExceptionUnitIssue.IssuingTechName);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.LoginTechName), TABLES.ExceptionUnitIssue.LoginTechName);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.IssueDateTime), TABLES.ExceptionUnitIssue.IssueDateTime);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.ExceptionUser), TABLES.ExceptionUnitIssue.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.ExceptionComment), TABLES.ExceptionUnitIssue.ExceptionComment);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.ExceptionDate), TABLES.ExceptionUnitIssue.ExceptionDate);
			Assert.AreEqual(true , dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitIssue.DivisionCode), TABLES.ExceptionUnitIssue.DivisionCode);
		}


		public static void ValidateExceptionReportLabelMismatch(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(15, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.ExceptionLabelMismatchGuid), TABLES.ExceptionLabelMismatch.ExceptionLabelMismatchGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.ModificationType), TABLES.ExceptionLabelMismatch.ModificationType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.TargetUnitId), TABLES.ExceptionLabelMismatch.TargetUnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.TargetUnitAboRh), TABLES.ExceptionLabelMismatch.TargetUnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.TargetProductType), TABLES.ExceptionLabelMismatch.TargetProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.TargetProductCode), TABLES.ExceptionLabelMismatch.TargetProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.TargetUnitExpirationDate), TABLES.ExceptionLabelMismatch.TargetUnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.ModificationDate), TABLES.ExceptionLabelMismatch.ModificationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.DiscrepantField), TABLES.ExceptionLabelMismatch.DiscrepantField);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.CorrectedValue), TABLES.ExceptionLabelMismatch.CorrectedValue);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.ExceptionComment), TABLES.ExceptionLabelMismatch.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.ExceptionUser), TABLES.ExceptionLabelMismatch.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.ExceptionDate), TABLES.ExceptionLabelMismatch.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionLabelMismatch.TestingTechName), TABLES.ExceptionLabelMismatch.TestingTechName);

		}

		public static void ValidateExceptionReportPatientAboRH(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(13, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.ExceptionPatientAboRhGuid), TABLES.ExceptionPatientAboRh.ExceptionPatientAboRhGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.PatientName), TABLES.ExceptionPatientAboRh.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.PatientId), TABLES.ExceptionPatientAboRh.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.SpecimenUid), TABLES.ExceptionPatientAboRh.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.PreTestingAboRh), TABLES.ExceptionPatientAboRh.PreTestingAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.CurrentTechAboRh), TABLES.ExceptionPatientAboRh.CurrentTechAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.CurrentSystemAboRh), TABLES.ExceptionPatientAboRh.CurrentSystemAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.TestDate), TABLES.ExceptionPatientAboRh.TestDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.ExceptionComment), TABLES.ExceptionPatientAboRh.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.ExceptionUser), TABLES.ExceptionPatientAboRh.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.ExceptionDate), TABLES.ExceptionPatientAboRh.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRh.TestingTechName), TABLES.ExceptionPatientAboRh.TestingTechName);

		}

		public static void ValidateExceptionReportPatientAboRHDiscrepancy(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(19, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionPatientAboRhDiscrepancyGuid), TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionPatientAboRhDiscrepancyGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PatientName), TABLES.ExceptionPatientAboRhDiscrepancy.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PatientId), TABLES.ExceptionPatientAboRhDiscrepancy.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PreviousSpecimenUid), TABLES.ExceptionPatientAboRhDiscrepancy.PreviousSpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PreviousSpecimenAboRh), TABLES.ExceptionPatientAboRhDiscrepancy.PreviousSpecimenAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PreviousTestingTechName), TABLES.ExceptionPatientAboRhDiscrepancy.PreviousTestingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PreviousEntryTechName), TABLES.ExceptionPatientAboRhDiscrepancy.PreviousEntryTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PreviousTestingDivision), TABLES.ExceptionPatientAboRhDiscrepancy.PreviousTestingDivision);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.PreviousTestingDate), TABLES.ExceptionPatientAboRhDiscrepancy.PreviousTestingDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.CurrentSpecimenUid), TABLES.ExceptionPatientAboRhDiscrepancy.CurrentSpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.CurrentSpecimenAboRh), TABLES.ExceptionPatientAboRhDiscrepancy.CurrentSpecimenAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.CurrentTestingTechName), TABLES.ExceptionPatientAboRhDiscrepancy.CurrentTestingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.CurrentEntryTechName), TABLES.ExceptionPatientAboRhDiscrepancy.CurrentEntryTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.CurrentTestingDivision), TABLES.ExceptionPatientAboRhDiscrepancy.CurrentTestingDivision);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.CurrentTestingDate), TABLES.ExceptionPatientAboRhDiscrepancy.CurrentTestingDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionComment), TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionUser), TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionDate), TABLES.ExceptionPatientAboRhDiscrepancy.ExceptionDate);

		}

		public static void ValidateExceptionReportPatientAntigenDiscrepancy(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(16, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionPatientAntigenDiscrepancyGuid), TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionPatientAntigenDiscrepancyGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.PatientName), TABLES.ExceptionPatientAntigenDiscrepancy.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.PatientId), TABLES.ExceptionPatientAntigenDiscrepancy.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.SpecimenUid), TABLES.ExceptionPatientAntigenDiscrepancy.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ReagentName), TABLES.ExceptionPatientAntigenDiscrepancy.ReagentName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ReagentTypeName), TABLES.ExceptionPatientAntigenDiscrepancy.ReagentTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.LotNumber), TABLES.ExceptionPatientAntigenDiscrepancy.LotNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.LotExpirationDate), TABLES.ExceptionPatientAntigenDiscrepancy.LotExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ReagentManufacturerName), TABLES.ExceptionPatientAntigenDiscrepancy.ReagentManufacturerName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.HistoricSpecimenTestResults), TABLES.ExceptionPatientAntigenDiscrepancy.HistoricSpecimenTestResults);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.CurrentSpecimenTestResults), TABLES.ExceptionPatientAntigenDiscrepancy.CurrentSpecimenTestResults);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionComment), TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionUser), TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionDate), TABLES.ExceptionPatientAntigenDiscrepancy.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientAntigenDiscrepancy.TestingTechName), TABLES.ExceptionPatientAntigenDiscrepancy.TestingTechName);
		}

		public static void ValidateExceptionReportPatientTest(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(13, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionPatientTestGuid), TABLES.ExceptionPatientTest.ExceptionPatientTestGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.PatientName), TABLES.ExceptionPatientTest.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.PatientId), TABLES.ExceptionPatientTest.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.SpecimenUid), TABLES.ExceptionPatientTest.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestName), TABLES.ExceptionPatientTest.TestName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestInterp), TABLES.ExceptionPatientTest.TestInterp);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestDate), TABLES.ExceptionPatientTest.TestDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ReactivityPhase), TABLES.ExceptionPatientTest.ReactivityPhase);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionComment), TABLES.ExceptionPatientTest.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionUser), TABLES.ExceptionPatientTest.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.ExceptionDate), TABLES.ExceptionPatientTest.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTest.TestingTechName), TABLES.ExceptionPatientTest.TestingTechName);
		}

		public static void ValidateExceptionReportPatientTestInactivated(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(12, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.ExceptionPatientTestInactivatedGuid), TABLES.ExceptionPatientTestInactivated.ExceptionPatientTestInactivatedGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.PatientName), TABLES.ExceptionPatientTestInactivated.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.PatientId), TABLES.ExceptionPatientTestInactivated.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.SpecimenUid), TABLES.ExceptionPatientTestInactivated.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.TestName), TABLES.ExceptionPatientTestInactivated.TestName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.InactivationDate), TABLES.ExceptionPatientTestInactivated.InactivationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.CurrentTechName), TABLES.ExceptionPatientTestInactivated.CurrentTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.ExceptionComment), TABLES.ExceptionPatientTestInactivated.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.ExceptionUser), TABLES.ExceptionPatientTestInactivated.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.ExceptionDate), TABLES.ExceptionPatientTestInactivated.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionPatientTestInactivated.TestingTechName), TABLES.ExceptionPatientTestInactivated.TestingTechName);
		}

		public static void ValidateExceptionReportExpiredUnitReceived(DataSet dsTest)
		{
			Assert.AreEqual(1,dsTest.Tables.Count,"Tables.Count");
			Assert.AreEqual(15,dsTest.Tables[0].Columns.Count,"Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ExceptionExpiredUnitReceivedGuid), TABLES.ExceptionExpiredUnitReceived.ExceptionExpiredUnitReceivedGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeId), TABLES.ExceptionType.ExceptionTypeId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.UnitId), TABLES.ExceptionExpiredUnitReceived.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.UnitGuid), TABLES.ExceptionExpiredUnitReceived.UnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.UnitAboRh), TABLES.ExceptionExpiredUnitReceived.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ProductType), TABLES.ExceptionExpiredUnitReceived.ProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ProductCode), TABLES.ExceptionExpiredUnitReceived.ProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ExceptionDate), TABLES.ExceptionExpiredUnitReceived.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.IncomingShipmentDate), TABLES.ExceptionExpiredUnitReceived.IncomingShipmentDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ProcessingTechId), TABLES.ExceptionExpiredUnitReceived.ProcessingTechId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ProcessingTechName), TABLES.ExceptionReturnedUnit.ProcessingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(ARTIFICIAL.ExceptionUserName), ARTIFICIAL.ExceptionUserName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ExceptionComment), TABLES.ExceptionExpiredUnitReceived.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionExpiredUnitReceived.ExceptionDate), TABLES.ExceptionExpiredUnitReceived.ExceptionDate);
		}

		public static void ValidateExceptionReportQC(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(14, dsTest.Tables[0].Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ReagentName), TABLES.ExceptionQc.ReagentName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.LotNumber), TABLES.ExceptionQc.LotNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.LotExpirationDate), TABLES.ExceptionQc.LotExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ReagentManufacturerName), TABLES.ExceptionQc.ReagentManufacturerName);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ReagentTypeName), TABLES.ExceptionQc.ReagentTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ExceptionComment), TABLES.ExceptionQc.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ExceptionUser), TABLES.ExceptionQc.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ExceptionDate), TABLES.ExceptionQc.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.RackName), TABLES.ExceptionQc.RackName);
			
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.PreviousResult), TABLES.ExceptionQc.PreviousResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.CurrentResult), TABLES.ExceptionQc.CurrentResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.ReactivityPhase), TABLES.ExceptionQc.ReactivityPhase);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQc.TestingTechName), TABLES.ExceptionQc.TestingTechName);
		}

		public static void ValidateExceptionReportQCInactivated(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(12, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivation.ExceptionQcInactivationGuid), TABLES.ExceptionQcInactivation.ExceptionQcInactivationGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivation.ExceptionComment), TABLES.ExceptionQcInactivation.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivation.ExceptionUser), TABLES.ExceptionQcInactivation.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivation.ExceptionDate), TABLES.ExceptionQcInactivation.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivation.ReagentRack), TABLES.ExceptionQcInactivation.ReagentRack);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivation.TestingTechName), TABLES.ExceptionQcInactivation.TestingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivationReagent.ReagentTypeName), TABLES.ExceptionQcInactivationReagent.ReagentTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivationReagent.TestWithName), TABLES.ExceptionQcInactivationReagent.TestWithName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivationReagent.IsResult), TABLES.ExceptionQcInactivationReagent.IsResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivationReagent.IatResult), TABLES.ExceptionQcInactivationReagent.IatResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcInactivationReagent.CcResult), TABLES.ExceptionQcInactivationReagent.CcResult);
		}

		public static void ValidateExceptionReportQCNotPerformed(DataSet dsTest, bool usingPatientGuid)
		{
			int columnCount = usingPatientGuid ? 10 : 12;

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(columnCount, dsTest.Tables[0].Columns.Count, "1-Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.ExceptionQcNotPerformedGuid), TABLES.ExceptionQcNotPerformed.ExceptionQcNotPerformedGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.PatientName), TABLES.ExceptionQcNotPerformed.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.PatientId), TABLES.ExceptionQcNotPerformed.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.SpecimenUid), TABLES.ExceptionQcNotPerformed.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.RackName), TABLES.ExceptionQcNotPerformed.RackName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.ExceptionComment), TABLES.ExceptionQcNotPerformed.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.ExceptionUser), TABLES.ExceptionQcNotPerformed.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.ExceptionDate), TABLES.ExceptionQcNotPerformed.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.TestingTechName), TABLES.ExceptionQcNotPerformed.TestingTechName);
			
			if (!usingPatientGuid)
			{
				Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.UnitId), TABLES.ExceptionQcNotPerformed.UnitId);
				Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQcNotPerformed.ProductCode), TABLES.ExceptionQcNotPerformed.ProductCode);
			}
		}

		public static void ValidateExceptionReportQuarantine(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(14, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.ExceptionQuarantineGuid), TABLES.ExceptionQuarantine.ExceptionQuarantineGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.PatientName), TABLES.ExceptionQuarantine.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.PatientId), TABLES.ExceptionQuarantine.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.UnitId), TABLES.ExceptionQuarantine.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.UnitProductType), TABLES.ExceptionQuarantine.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.UnitProductCode), TABLES.ExceptionQuarantine.UnitProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.UnitAboRh), TABLES.ExceptionQuarantine.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.UnitExpirationDate), TABLES.ExceptionQuarantine.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.UnitAntigenTypingResult), TABLES.ExceptionQuarantine.UnitAntigenTypingResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.ExceptionComment), TABLES.ExceptionQuarantine.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.ExceptionUser), TABLES.ExceptionQuarantine.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.ExceptionDate), TABLES.ExceptionQuarantine.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionQuarantine.TestingTechName), TABLES.ExceptionQuarantine.TestingTechName);
		}

		public static void ValidateExceptionReportReflexTest(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(11, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.ExceptionReflexTestGuid), TABLES.ExceptionReflexTest.ExceptionReflexTestGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.PatientName), TABLES.ExceptionReflexTest.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.PatientId), TABLES.ExceptionReflexTest.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.SpecimenUid), TABLES.ExceptionReflexTest.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.SpecimenExpirationDate), TABLES.ExceptionReflexTest.SpecimenExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.TestOrdered), TABLES.ExceptionReflexTest.TestOrdered);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.ExceptionComment), TABLES.ExceptionReflexTest.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.ExceptionUser), TABLES.ExceptionReflexTest.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.ExceptionDate), TABLES.ExceptionReflexTest.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReflexTest.TestingTechName), TABLES.ExceptionReflexTest.TestingTechName);
		}

		public static void ValidateExceptionReportSpecimen(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(16, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.ExceptionSpecimenGuid), TABLES.ExceptionSpecimen.ExceptionSpecimenGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.PatientName), TABLES.ExceptionSpecimen.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.PatientId), TABLES.ExceptionSpecimen.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.PatientAntibodies), TABLES.ExceptionSpecimen.PatientAntibodies);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.LastTransfusionDateTime), TABLES.ExceptionSpecimen.LastTransfusionDateTime);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.SpecimenUid), TABLES.ExceptionSpecimen.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.SpecimenExpirationDate), TABLES.ExceptionSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.ExtendedExpirationDate), TABLES.ExceptionSpecimen.ExtendedExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.ComponentClassOrdered), TABLES.ExceptionSpecimen.ComponentClassOrdered);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.DateWanted), TABLES.ExceptionSpecimen.DateWanted);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.DateOrderAccepted), TABLES.ExceptionSpecimen.DateOrderAccepted);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.ExceptionComment), TABLES.ExceptionSpecimen.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.ExceptionUser), TABLES.ExceptionSpecimen.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.ExceptionDate), TABLES.ExceptionSpecimen.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionSpecimen.TestingTechName), TABLES.ExceptionSpecimen.TestingTechName);
		}

		public static void ValidateExceptionReportUnitAboRh(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(11, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.ExceptionUnitAboRhGuid), TABLES.ExceptionUnitAboRh.ExceptionUnitAboRhGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.UnitId), TABLES.ExceptionUnitAboRh.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.UnitProductType), TABLES.ExceptionUnitAboRh.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.UnitExpirationDate), TABLES.ExceptionUnitAboRh.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.LoginUnitAboRh), TABLES.ExceptionUnitAboRh.LoginUnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.UnitAboRhInterp), TABLES.ExceptionUnitAboRh.UnitAboRhInterp);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.ExceptionComment), TABLES.ExceptionUnitAboRh.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.ExceptionUser), TABLES.ExceptionUnitAboRh.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.ExceptionDate), TABLES.ExceptionUnitAboRh.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitAboRh.TestingTechName), TABLES.ExceptionUnitAboRh.TestingTechName);
		}

		public static void ValidateExceptionReportUnitModification(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(15, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ExceptionUnitModificationGuid), TABLES.ExceptionUnitModification.ExceptionUnitModificationGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ModificationType), TABLES.ExceptionUnitModification.ModificationType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitId), TABLES.ExceptionUnitModification.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitAboRh), TABLES.ExceptionUnitModification.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitProductType), TABLES.ExceptionUnitModification.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitProductCode), TABLES.ExceptionUnitModification.UnitProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.UnitExpirationDate), TABLES.ExceptionUnitModification.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ModificationDate), TABLES.ExceptionUnitModification.ModificationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ComponentName), TABLES.ExceptionUnitModification.ComponentName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.RecommendedExpirationDate), TABLES.ExceptionUnitModification.RecommendedExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ModifyingTech), TABLES.ExceptionUnitModification.ModifyingTech);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ExceptionComment), TABLES.ExceptionUnitModification.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ExceptionUser), TABLES.ExceptionUnitModification.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitModification.ExceptionDate), TABLES.ExceptionUnitModification.ExceptionDate);
		}

		public static void ValidateExceptionReportUnitSelection(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(20, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.ExceptionUnitSelectionGuid), TABLES.ExceptionUnitSelection.ExceptionUnitSelectionGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.PatientName), TABLES.ExceptionUnitSelection.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.PatientId), TABLES.ExceptionUnitSelection.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.PatientCurrentAboRh), TABLES.ExceptionUnitSelection.PatientCurrentAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.PatientHistoricalAboRh), TABLES.ExceptionUnitSelection.PatientHistoricalAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.PatientAntibodies), TABLES.ExceptionUnitSelection.PatientAntibodies);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.ComponentRequirements), TABLES.ExceptionUnitSelection.ComponentRequirements);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.AntigenNegativeRequirements), TABLES.ExceptionUnitSelection.AntigenNegativeRequirements);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.UnitId), TABLES.ExceptionUnitSelection.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.UnitProductType), TABLES.ExceptionUnitSelection.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.UnitAboRh), TABLES.ExceptionUnitSelection.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.UnitExpirationDate), TABLES.ExceptionUnitSelection.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.AntigenTypingResult), TABLES.ExceptionUnitSelection.AntigenTypingResult);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.DonationType), TABLES.ExceptionUnitSelection.DonationType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.SelectionDate), TABLES.ExceptionUnitSelection.SelectionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.ExceptionComment), TABLES.ExceptionUnitSelection.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.ExceptionUser), TABLES.ExceptionUnitSelection.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.ExceptionDate), TABLES.ExceptionUnitSelection.ExceptionDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionUnitSelection.TestingTechName), TABLES.ExceptionUnitSelection.TestingTechName);
		}

		public static void ValidateExceptionReportReturnIssuedUnit(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(15, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ExceptionReturnedUnitGuid), TABLES.ExceptionReturnedUnit.ExceptionReturnedUnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.PatientName), TABLES.ExceptionReturnedUnit.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.PatientId), TABLES.ExceptionReturnedUnit.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.PatientAboRh), TABLES.ExceptionReturnedUnit.PatientAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ReturnedUnitId), TABLES.ExceptionReturnedUnit.ReturnedUnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ReturnedUnitProductShortName), TABLES.ExceptionReturnedUnit.ReturnedUnitProductShortName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ReturnedUnitAboRh), TABLES.ExceptionReturnedUnit.ReturnedUnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ReturnedUnitExpirationDate), TABLES.ExceptionReturnedUnit.ReturnedUnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.IssueToLocation), TABLES.ExceptionReturnedUnit.IssueToLocation);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.VisualInspectionIndicator), TABLES.ExceptionReturnedUnit.VisualInspectionIndicator);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ProcessingTechName), TABLES.ExceptionReturnedUnit.ProcessingTechName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ExceptionComment), TABLES.ExceptionReturnedUnit.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ExceptionUser), TABLES.ExceptionReturnedUnit.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionReturnedUnit.ExceptionDate), TABLES.ExceptionReturnedUnit.ExceptionDate);
		}

		public static void ValidateExceptionReportAboIncompatibleTransfusion(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(12, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionTransfusionGuid), TABLES.ExceptionTransfusion.ExceptionTransfusionGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitId), TABLES.ExceptionTransfusion.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitProductType), TABLES.ExceptionTransfusion.UnitProductType);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitAboRh), TABLES.ExceptionTransfusion.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.UnitExpirationDate), TABLES.ExceptionTransfusion.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.TransfusedPatientName), TABLES.ExceptionTransfusion.TransfusedPatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.TransfusedPatientId), TABLES.ExceptionTransfusion.TransfusedPatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.TransfusedPatientAboRh), TABLES.ExceptionTransfusion.TransfusedPatientAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionComment), TABLES.ExceptionTransfusion.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionUser), TABLES.ExceptionTransfusion.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionTransfusion.ExceptionDate), TABLES.ExceptionTransfusion.ExceptionDate);
		}

		public static void ValidateExceptionReportCautionTagBTRF(DataSet dsTest)
		{
			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(16, dsTest.Tables[0].Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeId), TABLES.ExceptionType.ExceptionTypeId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionType.ExceptionTypeName), TABLES.ExceptionType.ExceptionTypeName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.ExceptionCautionTagGuid), TABLES.ExceptionCautionTag.ExceptionCautionTagGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.SpecimenUid), TABLES.ExceptionCautionTag.SpecimenUid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.PatientName), TABLES.ExceptionCautionTag.PatientName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.PatientId), TABLES.ExceptionCautionTag.PatientId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.PatientGuid), TABLES.ExceptionCautionTag.PatientGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.PatientAboRh), TABLES.ExceptionCautionTag.PatientAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.UnitId), TABLES.ExceptionCautionTag.UnitId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.UnitGuid), TABLES.ExceptionCautionTag.UnitGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.ProductCode), TABLES.ExceptionCautionTag.ProductCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.UnitAboRh), TABLES.ExceptionCautionTag.UnitAboRh);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.UnitExpirationDate), TABLES.ExceptionCautionTag.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.ExceptionUser), TABLES.ExceptionCautionTag.ExceptionUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.ExceptionComment), TABLES.ExceptionCautionTag.ExceptionComment);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ExceptionCautionTag.ExceptionDate), TABLES.ExceptionCautionTag.ExceptionDate);
		}

		#endregion

	}
}
#endif
